$(document).ready(function(){

	$('select').dropdown();

	
	$('.editComment').click(function(){
		$('#editComment').modal({
			blurring: false
		}).modal('show');
		
		var condition = jQuery.parseJSON($(this).attr('data-condition'));
		var id = $(this).attr('data-id');
		
		$('#editComment select[name="type"]').dropdown('set selected', condition.type);
		
		$('#editComment [name="id"]').val(id);
		$('#editComment [name="exception"]').val($(this).attr('data-exception'));
		$('#editComment [name="mess"]').val($(this).attr('data-mess'));		
		$('#editComment select[name="state"]').dropdown('set selected', $(this).attr('data-state'));
		
		$('#editComment [name="sm_title"]').show();
		
		if (condition.type == 'regular_wd'){
			$('#editComment .condition select option').removeAttr('selected');
			$.each(condition.w_days, function(n, m){
				$('#editComment .condition select').dropdown('set selected', m);
			})
			$('#editComment .condition [name="time"]').val(condition.time);
		}else if(condition.type == 'regular_md'){
			$.each(condition.m_days, function(n, m){
				$('#editComment .condition select').dropdown('set selected', m);
			})
			$('#editComment .condition [name="time"]').val(condition.time);
		}else if(condition.type == 'regular_date' || condition.type == 'single'){
			$('#editComment .condition input').val(condition.date+' '+condition.time);
		}else if(condition.type == 'birthday'){
			$('#editComment .condition input').val(condition.date);
			$('#editComment [name="time"]').val(condition.time);
		}
		$('#editComment [name="attachment"]').val($('#attach'+id).html());
		$('#editComment [name="sm_title"]').val($(this).attr('data-sm_title'));
		
		if(condition.type == 'birthday'){
			$('#editComment [name="attachment"]').hide();
			$('#editComment [name="sm_title"]').show();
		}else{
			$('#editComment [name="attachment"]').show();
			//$('#editComment [name="sm_title"]').hide();
		}
		
		
		return false;
	})

	$('.deleteComment').click(function(){
		
		var id = 'id=' + $(this).attr('data-id');

		$.ajax({
			url: 'index.php?task=delete&type=json',
			dataType: 'json',
			data: id, 
			method: 'POST',
			success: function(data){
				location.reload();
			},
			error:  function(xhr, str){
				alert('Возникла ошибка: ' + xhr.responseCode);
			}
		});
		return false;
	})
	
	$('#addStory').click(function(){
		$('#editComment').modal({
			blurring: false
		}).modal('show');	
		
		$('#editComment [name="id"]').val('0');
		$('#editComment [name="condition"]').val('');
		$('#editComment [name="exception"]').val('');
		$('#editComment [name="mess"]').val('');
		$('#editComment [name="attachment"]').val('');
		$('#editComment [name="sm_title"]').val('');
		
		$('#editComment select[name="state"]').dropdown('set selected', 0);
		return false;
	})

	$( ".type_select" ).change(function() {
		switch ($(".type_select option:selected").val()) {
		  case 'single':
		    $(".condition").replaceWith('<div class="ui calendar single condition"><div class="ui input left icon"><i class="calendar icon"></i><input type="text" name="condition" placeholder="Дата/Время отправки"></div></div>');

			$(".single input").datetimepicker({
				format:'Y-m-d H:i'
			});
		    break;
		  case 'regular_wd':
		    $(".condition").replaceWith('<div class="condition"><select name="condition[]" multiple="" class="ui fluid dropdown"><option value="">Выберите дни отправки</option><option value="1">Понедельник</option><option value="2">Вторник</option><option value="3">Среда</option><option value="4">Четверг</option><option value="5">Пятница</option><option value="6">Суббота</option><option value="7">Воскресенье</option></select><input type="text" name="time" placeholder="время, например 12:00" /></div>');
		    $('.ui.dropdown').dropdown();
		    break;
		  case 'regular_md':
		    $(".condition").replaceWith('<div class="condition"><select name="condition[]" multiple="" class="ui fluid dropdown"><option value="">Выберите дни отправки</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option><option value="16">16</option><option value="17">17</option><option value="18">18</option><option value="19">19</option><option value="20">20</option><option value="21">21</option><option value="22">22</option><option value="23">23</option><option value="24">24</option><option value="25">25</option><option value="26">26</option><option value="27">27</option><option value="28">28</option><option value="29">29</option><option value="30">30</option><option value="31">31</option></select><input type="text" name="time" placeholder="время, например 12:00" /></div>');
		    $('.ui.dropdown').dropdown();
		    break;
		  case 'regular_date':
		    $(".condition").replaceWith('<div class="ui calendar regular_date condition"><div class="ui input left icon"><i class="calendar icon"></i><input type="text" name="condition" placeholder="Дата/Время отправки"></div></div>');
			$(".regular_date input").datetimepicker({
				format:'Y-m-d H:i'
			});
		    break;
		  case 'birthday':
			$(".condition").replaceWith('<div class="ui calendar regular_date condition"><div class="ui input left icon"><i class="calendar icon"></i><input type="text" name="condition" placeholder="День рождения"></div><input type="text" name="time" placeholder="время напоминания, например 12:00" /></div>');
			$(".regular_date .ui.input input").datetimepicker({
				timepicker:false,
				format:'Y-m-d'
			});
			break;
		  default:
		    alert( 'Что-то пошло не так' );
		}
		
		if($(".type_select option:selected").val() == 'birthday'){
			$('#editComment [name="attachment"]').hide();
			$('#editComment [name="sm_title"]').show();
		}else{
			//$('#editComment [name="sm_title"]').hide();
			$('#editComment [name="attachment"]').show();
		}
		
	});
	
})